;
;***********************
;  DEMO RELAY & SSRAC  *
;     EXPERIMENT 3     *
;***********************

           CPU   "Z80.TBL"
           HOF   "INT8"

           ORG   2000H
P_LED:     EQU   0B4H
P_SEG:     EQU   60H
NUM_PORT:  EQU   1
DIPSW:      EQU   0A0H
CTRL:       EQU   0B7H
SYSFAG:     EQU   3FFDH
DISPY:      EQU   3FE7H
SCAN:       EQU   2
SYSCAL:     EQU   10H
KDEC:       EQU   11H
KINC:       EQU   13H
IN2:        EQU   8
;
;/*  START INITIAL */

MAIN:
           LD   HL,0              ;Clear temp & real data
           LD   (TEMP_BUF),HL
           LD   (DSPNUM),HL
           LD   (ON_OFF),HL
           LD   A,8BH
           OUT  (CTRL),A
           LD   A,0FFH
           OUT  (P_LED),A
           LD   A,(SYSFAG)
           SETT 4,A
           LD   (SYSFAG),A
;
MAIN1:     LD   HL,TAB_MAIN
           LD   DE,DISPY
           LD   BC,6
           LDIR
           LD   A,SCAN
           RST  SYSCAL
           CP   KDEC
           JR   Z,OFF
           CP   KINC
           JR   Z,ON
           JR   MAIN1
;
OFF:       LD   IX,DSPNUM
           LD   B,71H
           LD   A,IN2
           RST  SYSCAL
           LD   (IX+0),A
           OR   A
           JR   Z,MAIN1
           LD   E,A
           CALL OFF_PORT
           JR   MAIN1
;
ON:        LD   IX,DSPNUM+1
           LD   B,5CH
           LD   A,IN2
           RST  SYSCAL
           LD   (IX+0),A
           OR   A
           JR   Z,MAIN1
           LD   E,A
           CALL ON_PORT
           JR   MAIN1

;
;***********************
;      ON PORT BIT     *
;***********************
;  I/P  =  E (Number bit port BCD)
;
ON_PORT:   LD   A,00000000B       ;load every TEMP = 0 whit LOGIC ON
           LD   C,10000000B       ;for set CARRY to ON BIT
           CALL GET_ONOFF         ;shift 1 of REG C to position BIT ON

           LD   HL,ON_OFF         ;load address real data
           LD   DE,TEMP_BUF       ;load address temp
           LD   B,NUM_PORT        ;load counter of buffer data

ON_P1:     LD   A,(DE)            ;LOGIC OR in tempbuf at position BIT ON
           OR   (HL)              ;TO buffer REAL DATA
           LD   (HL),A
           INC  HL
           INC  DE
           DJNZ ON_P1
           CALL OUT_PORT          ;NEW real buffer data to port
           RET
;
;***********************
;      OFF PORT BIT    *
;***********************
;  I/P = E (number bit port BCD)

OFF_PORT:  LD   A,11111111B       ;load every TEMP = 1 with LOGIC AND
           LD   C,01111111B       ;for reset CARRY to OFF BIT
           CALL GET_ONOFF         ;shift 0 of REG C to position BIT OFF

           LD   HL,ON_OFF
           LD   DE,TEMP_BUF
           LD   B,NUM_PORT

OFF_P1:    LD   A,(DE)            ;LOGIC AND in tempbuf at position BIT OFF
           AND  (HL)              ;TO buffer REAL DATA
           LD   (HL),A
           INC  HL
           INC  DE
           DJNZ OFF_P1
           CALL OUT_PORT          ;NEW real buffer data to port
           RET
;
;***********************
;  SUB FOR GET ON-OFF  *
;***********************
;
GET_ONOFF:
           LD   HL,TEMP_BUF      ;FILL every temp on,off follow reg A
           LD   B,NUM_PORT       ;Counter buffer
GET_ONF:   LD   (HL),A
           INC  HL
           DJNZ GET_ONF
           LD   A,E              ;BIT ON,OFF
;
GET_ONF1:  LD   HL,TEMP_BUF      ;
           RL   C                ;SHIFT BIT 7 TO CARRY FLAG
           LD   B,NUM_PORT
GET_ONF2:  RL   (HL)             ;SHIFT CARRY TO TEMP
           INC  HL
           DJNZ GET_ONF2         ;SHIFT ONCE EVERY TEMP
           RR   C                ;Save carry flag
           SUB  1                ;dec counter bit ON,OFF
           DAA                   ;BIT ON,OFF = decimal
           JR   NZ,GET_ONF1      ;Not address bit on find continute
           RET
;
;***********************
;SEND REAL DATA TO PORT*
;***********************

OUT_PORT:  LD   HL,ON_OFF        ;Send real data to port
           LD   A,(HL)
           CPLA
           OUT  (P_LED),A
           RET
;
;/*  DATA TABLE OF DISPLAY & COMMAND */

TAB_MAIN:  DFB  5CH,54H,40H,5CH,71H,71H

;
;/*  RAM WORKING AREA FOR BUFFER & REAL DATA */

           ORG  3000H
TEMP_BUF:  DFS   NUM_PORT         ;buffer to temporary
ON_OFF:    DFS   NUM_PORT         ;buffer real data
DSPNUM:    DFS   2
           END


